document.addEventListener('DOMContentLoaded', () => {
    const draggables = document.querySelectorAll('.draggable-word');
    const dropZones = document.querySelectorAll('.drop-zone');

    draggables.forEach(word => {
        word.addEventListener('dragstart', dragStart);
    });

    dropZones.forEach(zone => {
        zone.addEventListener('dragover', dragOver);
        zone.addEventListener('drop', dropWord);
    });

    document.getElementById('check-btn').addEventListener('click', checkAnswers);
    document.getElementById('restart-btn').addEventListener('click', resetGame);
});

function dragStart(event) {
    event.dataTransfer.setData('text', event.target.id);
}

function dragOver(event) {
    event.preventDefault();
}

function dropWord(event) {
    event.preventDefault();
    const wordId = event.dataTransfer.getData('text');
    const word = document.getElementById(wordId);

    // Si el drop zone está vacío, se coloca la palabra
    if (!event.target.textContent) {
        event.target.textContent = word.textContent;
        word.classList.add('used'); // Añade la clase "used" para ocultarlo
        word.style.display = 'none'; // Oculta la palabra del banco de palabras
    }
}

function checkAnswers() {
    const correctAnswers = {
        drop1: 'perro',
        drop2: 'pan',
        drop3: 'montaña',
        drop4: 'árbol',
        drop5: 'camisa',
        drop6: 'escuela',
        drop7: 'pollo',
        drop8: 'zorro',
        drop9: 'jugo',
        drop10: 'juguete'
    };

    let allCorrect = true;

    Object.keys(correctAnswers).forEach(id => {
        const userAnswer = document.getElementById(id).textContent;
        if (userAnswer !== correctAnswers[id]) {
            allCorrect = false;
        }
    });

    if (allCorrect) {
        document.getElementById('result-message').textContent = '¡FELICIDADES LO LOGRASTE ERES INCREIBLE!';
        document.getElementById('restart-btn').classList.add('hidden');
    } else {
        document.getElementById('result-message').textContent = 'Inténtalo de nuevo puedes lograrlo.';
        document.getElementById('restart-btn').classList.remove('hidden');
    }
}

function resetGame() {
    // Limpiar las zonas de arrastre
    const dropZones = document.querySelectorAll('.drop-zone');
    dropZones.forEach(zone => {
        zone.textContent = '';
    });

    // Hacer visibles nuevamente las palabras usadas
    const usedWords = document.querySelectorAll('.draggable-word.used');
    usedWords.forEach(word => {
        word.classList.remove('used'); // Quita la clase "used"
        word.style.display = 'inline-block'; // Muestra nuevamente las palabras
    });

    // Restablecer el mensaje
    document.getElementById('result-message').textContent = '';

    // Ocultar el botón "Inténtalo de nuevo"
    document.getElementById('restart-btn').classList.add('hidden');
}
